chrome.action.onClicked.addListener(async (tab) => {
  const prevState = await chrome.action.getBadgeText({ tabId: tab.id });

  if (prevState !== 'ON') {
    await chrome.action.setBadgeText({
      tabId: tab.id,
      text: 'ON',
    });
    await chrome.scripting.executeScript({
      target: { tabId: tab.id },
      files: ['editor.js'],
    });
  }
});

chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.type === 'download' && request.content) {
    let blob = new Blob([request.content], { type: 'text/html' });
    let reader = new FileReader();
    reader.onload = function (e) {
      chrome.downloads.download({
        url: e.target.result,
        filename: 'cyclone-export.html',
      });
    };
    reader.readAsDataURL(blob);
  }
});
